<?php
/**
 * RequestServer
 *
 * @author      Shopimind <contact@shopimind.com>
 * @copyright   Copyright (c) 2013 - IDVIVE SARL (http://www.idvive.com)
 * @license     New BSD license (http://license.idvive.com)
 * @package     ShopimindClient
 * @version     $Id RequestServer.php 2013-05-21$
 */

class ShopimindClientRequestServer
{

    private $client;

    private $response = array('success' => false);

    private $typeRequest = 'GET';

    public function __construct()
    {
        include_once dirname(__FILE__).'/../src/Client.php';
        $this->client = new ShopimindClientClient;
    }

    /**
     * Permet d'ajouter des paramètres à la requête
     *
     * @param string $name
     * @param string $value
     * @param string $method
     * @return ShopimindClientRequestServer
     */
    public function addParam($name, $value, $method = 'POST')
    {
        switch (Tools::strtolower($method)) {
            case 'get':
                $this->client->setParameterGet($name, $value);
                break;
            case 'post':
                $this->client->setParameterPost($name, $value);
                $this->typeRequest = 'POST';
                break;
        }

        return $this;
    }

    /**
     * Permet de parémétrer le service que l'on souhaite interroger
     *
     * @param string $restService
     * @return ShopimindClientRequestServer
     */
    public function setRestService($restService)
    {
        $this->client->setRestService($restService);

        return $this;
    }

    /**
     * Permet d'éxecuter la requête
     *
     * @return void
     */
    public function send()
    {
        $response = $this->client->sendRequest($this->typeRequest);
        if ($response !== null) {
            $this->setResponse($response);
        }

        return (is_array($response) && array_key_exists('success', $response) && $response['success'] == true);
    }

    /**
     * Permet de récupérer la réponse du serveur
     *
     * @return array
     */
    public function getResponse()
    {
        return $this->response;
    }

    /**
     * Permet de modifier la réponse du serveur
     *
     * @param array $response
     * @return ShopimindClientRequestServer
     */
    public function setResponse(array $response)
    {
        $this->response = $response;

        return $this;
    }
}
