<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    Presta.Site
 * @copyright 2015 Presta.Site
 * @license   LICENSE.txt
 */

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');
require_once(_PS_MODULE_DIR_.'prestabackup/classes/PSDbBackup.php');

$admin_cookie = new Cookie('psAdmin');
if ($admin_cookie->id_employee) {
    $is_admin = true;
    $employee = new Employee($admin_cookie->id_employee);
} else {
    $is_admin = false;
}

if (!$is_admin) {
    die(Tools::displayError('You do not have permission to view this.'));
}

$tabAccess = Profile::getProfileAccess(
    $employee->id_profile,
    Tab::getIdFromClassName('AdminBackup')
);

if ($tabAccess['view'] !== '1') {
    die(Tools::displayError('You do not have permission to view this.'));
}

$type = Tools::getValue('type', 'db');

if ($type == 'files') {
    $backupdir = realpath(PSDbBackup::getBackupPath('', '/modules/prestabackup/backup/files/'));
} else {
    $backupdir = realpath(PSDbBackup::getBackupPath());
}

if ($backupdir === false) {
    die(Tools::displayError('There is no "/backup" directory.'));
}

if (!$backupfile = Tools::getValue('filename')) {
    die(Tools::displayError('No file has been specified.'));
}

// Check the realpath so we can validate the backup file is under the backup directory
$backupfile = realpath($backupdir.DIRECTORY_SEPARATOR.$backupfile);

if ($backupfile === false or strncmp($backupdir, $backupfile, Tools::strlen($backupdir)) != 0) {
    die(Tools::dieOrLog('The backup file does not exist.'));
}

if (Tools::substr($backupfile, -4) == '.bz2') {
    $contentType = 'application/x-bzip2';
} else {
    if (Tools::substr($backupfile, -3) == '.gz') {
        $contentType = 'application/x-gzip';
    } else {
        $contentType = 'text/x-sql';
    }
}

if (file_exists($backupfile)) {
    if (ob_get_level()) {
        ob_end_clean();
    }

    header('Content-Description: File Transfer');
    header('Content-Type: application/octet-stream');
    header('Content-Disposition: attachment; filename='.basename($backupfile));
    header('Content-Transfer-Encoding: binary');
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: '.filesize($backupfile));
    if ($fd = fopen($backupfile, 'rb')) {
        while (!feof($fd)) {
            print fread($fd, 1024);
        }

        fclose($fd);
    } else {
        die(Tools::displayError('Unable to open backup file(s).').' "'.addslashes($backupfile).'"');
    }

    exit;
}
