{**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*}

{extends file=$layout}
{block name='head_seo_title'}
    {if isset($meta_title)}
        {$meta_title}
    {else}
        {$page.meta.title}
    {/if}
{/block}
{block name='head_seo_description'}
    {if isset($meta_desc)}
        {$meta_desc}
    {else}
        {$page.meta.description}
    {/if}
{/block}
{block name='head_seo_keywords'}
    {if isset($meta_keys)}
        {$meta_keys}
    {else}
        {$page.meta.keywords}
    {/if}
{/block}
{block name='content'}
    <div class="row wkblock">
        <div class="clearfix col-md-9 wkblock wk_shadow_box">
            {if !empty($post_content)}
                <div class="main_content">
                    <div class="clearfix wkbox wk_head">
                        <h1 class="wkblog-heading">
                            {$post_content.title}
                        </h1>
                        <div class="clearfix blog-info">
                            {if Configuration::get('WK_SHOW_AUTHOR_THUMBNAIL')}
                                <div class="clearfix wkblog_info">
                                    {assign var="path" value ="{$module_path}wkblogpost/views/img/default/custom-autor-profile.jpg"}
                                    {if file_exists($path)}
                                        <div class="clearfix wk_left wk_profile_img">
                                            <img
                                                class="wk-image-responsive"
                                                src="{$ps_module_dir}wkblogpost/views/img/default/custom-autor-profile.jpg"/>
                                        </div>
                                    {else}
                                        <div class="clearfix wk_left wk_profile_img">
                                            <img
                                                class="wk-image-responsive"
                                                src="{$ps_module_dir}wkblogpost/views/img/default/autor-profile.jpg"/>
                                        </div>
                                    {/if}
                                    <div class="clearfix wk_user_info wk_left">
                                        <span>{Configuration::get('WK_BLOG_POST_AUTHOR_NAME')}</span>
                                        <br/>
                                        <span>{$post_content.date_add|date_format:"%B %e, %Y"}</span>
                                    </div>
                                </div>
                            {else}

                            {/if}
                            <hr>
                        </div>
                    </div>
                    <div class="clearfix wk-blog-content wkbox ">
                        {assign var="path" value="{$module_path}wkblogpost/views/img/blog/{$post_content.id_wk_blog_post}/{$post_content.id_wk_blog_post}_blog.jpg"}
                        <div class="clearfix wk_feature_blog_img" style="text-align:center;">
                            {if file_exists($path)}
                                <img
                                    src="{$ps_module_dir}wkblogpost/views/img/blog/{$post_content.id_wk_blog_post}/{$post_content.id_wk_blog_post|intval}_blog.jpg?time={$time}" style="max-width:100%"/>
                            {else}
                                {assign var="custom_img_path" value="{$module_path}wkblogpost/views/img/default/custom-default.jpg"}
                                {if file_exists($custom_img_path)}
                                    <img
                                    class="wk-image-responsive"
                                    src="{$ps_module_dir}wkblogpost/views/img/default/custom-default.jpg" style="max-width:100%;"/>
                                {else}
                                    <img
                                    class="wk-image-responsive"
                                    src="{$ps_module_dir}wkblogpost/views/img/default/home-default.png" style="max-width:100%;"/>
                                {/if}
                            {/if}
                            <div class="wk-category-name">
                                <span>{l s='Category:' mod='wkblogpost'} <a href="{$link->getModuleLink('wkblogpost', 'categorypost', ['cat' => {$category->link_rewrite}])}">{$category->title|ucfirst}</a></span>
                            </div>
                        </div>
                        <div class="blog_description">
                            {$post_content.description nofilter}
                        </div>
                    </div>
                </div>
            {else}
                {include file="module:wkblogpost/views/templates/front/wk_no_found.tpl"}
            {/if}
        </div>
        <div class=" col-xs-12 col-sm-12 col-md-3">
            <div id="search_block_top">
                <form method="get" action="{$link->getModuleLink('wkblogpost', 'search')}">
                    {if !$wk_rewrite_enabled}
                        <input type="hidden" name="fc" value="module"/>
                        <input type="hidden" name="module" value="wkblogpost"/>
                        <input type="hidden" name="controller" value="search"/>
                    {/if}
                    <div class="clearfix wkblog_search block-categories">
                        <input
                            type="text"
                            value=""
                            placeholder="{l s='Search Blog' mod='wkblogpost'}"
                            name="q"
                            class="form-control"
                            autocomplete="off">
                        <button
                            type="submit">
                            <i class="material-icons search"></i>
                        </button>
                    </div>
                </form>
            </div>
            {if isset($category_on) && $category_on == 1}
                <div class="wk-recent-blog wkbox wk_post_category clearfix wk_shadow_box">
                    <div class="wktitle">
                        <span>{l s='Blog Categories' mod='wkblogpost'}</span>
                    </div>
                    <hr>
                    {if !empty($all_category)}
                        {foreach $all_category as $key => $cat}
                            {if $key+1 <= $no_cat}
                                <div class="wkcontent">
                                    <h3>
                                        <a
                                            {if isset($post_content)}
                                            {if $cat.title == $post_content.cat_title}
                                            class="active"
                                            {/if}
                                            {/if}
                                            href="{$link->getModuleLink('wkblogpost', 'categorypost', ['cat' => {$cat.link_rewrite}])}">{$cat.title}</a>
                                    </h3>
                                </div>
                            {/if}
                        {/foreach}
                    {else}
                        <div class="wkcontent">
                            <h4>{l s='No Category Found' mod='wkblogpost'}</h4>
                        </div>
                    {/if}
                </div>
            {/if}
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <hr>

        </div>
    </div>
{/block}
{$layout}