{**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*}

<div class="panel">
	<div class="panel-heading">
		<i class="icon-user"></i>
			{if isset($id_cat)}
				{l s='Update Category' mod='wkblogpost'}
			{else}
				{l s='New Category' mod='wkblogpost'}
			{/if}
	</div>
    <form id="{$table}_form" class="defaultForm form-horizontal" action="{$current}&{if isset($id_cat)}update{$table}&id_wk_blogpost_category={$id_cat|intval}{else}add{$table}{/if}&token={$token}" method="post" enctype="multipart/form-data">
        <input type="hidden" value="{if isset($id_cat)}{$id_cat|intval}{/if}" name="id">
    	<div class="form-group">
    		<label class="control-label col-lg-3 required">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
    				{l s='Title' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
    			{foreach from=$languages item=language}
                    {assign var="wkcat_title" value="wkcat_title_`$language.id_lang`"}
                    <input type="text" id="name_{$language.id_lang}" name="wkcat_title_{$language.id_lang}" value="{if isset($id_cat) && isset($obj_wkcat) && isset($obj_wkcat->title.{$language.id_lang})}{$obj_wkcat->title.{$language.id_lang}}{else if isset($smarty.post.$wkcat_title)}{$smarty.post.$wkcat_title}{/if}" class="form-control copyMeta2friendlyURL all_wkfield" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();"
                    {if $id_lang != $language.id_lang}style="display:none;"{/if} />
                {/foreach}
            </div>
            {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="title_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
    	<div class="form-group">
    		<label class="control-label col-lg-3 required">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Only letters and the hyphen (-) character are allowed.' mod='wkblogpost'}">
    				{l s='Friendly URL' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
                {foreach from=$languages item=language}
                    {assign var="link_rewrite_" value="link_rewrite_`$language.id_lang`"}
                    <input type="text" id="link_rewrite_{$language.id_lang}" name="link_rewrite_{$language.id_lang}" value="{if isset($obj_wkcat) && isset($obj_wkcat->link_rewrite.{$language.id_lang})}{$obj_wkcat->link_rewrite.{$language.id_lang}}{else if isset($smarty.post.$link_rewrite_)}{$smarty.post.$link_rewrite_}{/if}" class="form-control all_wkfield" onkeyup="if (isArrowKey(event)) return ;updateFriendlyURL();"
                    {if $id_lang != $language.id_lang}style="display:none;"{/if} />
                {/foreach}
            </div>
            {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="link_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
    	<div class="form-group">
            <label for="file" class="control-label col-lg-3">
                <span class="label-tooltip" data-toggle="tooltip" title="{l s='Upload a image from your computer.' mod='wkblogpost'}">{l s='Featured Image' mod='wkblogpost'}</span>
            </label>
            <div class="col-sm-9">
                <div class="row">
                    <div class="col-lg-7">
                        <input id="file" type="file" name="wkcat_featured" class="hide" />
                        <div class="dummyfile input-group">
                            <span class="input-group-addon"><i class="icon-file"></i></span>
                            <input id="file-name" type="text" class="disabled" name="filename" readonly />
                            <span class="input-group-btn">
                                <button id="file-selectbutton" type="button" name="submitAddAttachments" class="btn btn-default">
                                    <i class="icon-folder-open"></i> {l s='Choose a file' mod='wkblogpost'}
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {if isset($image_exist)}
        <div class="form-group">
            <label class="control-label col-lg-3">

            </label>
            <div class="col-lg-7 featured_cat">
                <img class="wkfeature_img" src="{$module_dir}/wkblogpost/views/img/category/{$id_cat|intval}_cat.jpg" title="{l s='Feature Image' mod='wkblogpost'}">
                <p>
                    <a href="{$link->getAdminLink('AdminWkCategoryPost')}&amp;id_delete={$id_cat|intval}" class="btn btn-default">
                    <i class="icon-trash"></i>{l s='Delete' mod='wkblogpost'}
                </a>
            </div>
        </div>
        {/if}
    	<div class="form-group">
			<label class="control-label col-lg-3" for="product_description">
				<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Describe about the category' mod='wkblogpost'}">
    				{l s='Description :' mod='wkblogpost'}
    			</span>
			</label>
			<div class="col-lg-8">
                {foreach from=$languages item=language}
                    {assign var="wkcat_desc" value="wkcat_desc_`$language.id_lang`"}
                    <div id="div_wkcat_desc_{$language.id_lang}" class="all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
                        <textarea id="wkcat_desc_{$language.id_lang}" name="wkcat_desc_{$language.id_lang}" class="wkblog_tinymce form-control" >{if isset($obj_wkcat) && isset($obj_wkcat->description.{$language.id_lang})}{$obj_wkcat->description.{$language.id_lang}}{/if}</textarea>
                    </div>
                {/foreach}
			</div>
            {if $total_languages > 1}
            <div class="col-lg-1">
                <button type="button" id="desc_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
		</div>
    	<div class="form-group">
    		<label class="control-label col-lg-3">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
    				{l s='Meta Title' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkcat_meta_title" value="wkcat_meta_title_`$language.id_lang`"}
    			<input type="text" name="wkcat_meta_title_{$language.id_lang}" value="{if isset($obj_wkcat) && isset($obj_wkcat->meta_title.{$language.id_lang})}{$obj_wkcat->meta_title.{$language.id_lang}}{/if}" id="wkcat_meta_title_{$language.id_lang}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
    		</div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_title_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
        <div class="form-group">
            <label class="control-label col-lg-3">
                <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Invalid characters <>;=#\{\}' mod='wkblogpost'}">
                    {l s='Meta Description' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkcat_meta_desc" value="wkcat_meta_desc_`$language.id_lang`"}
                <input type="text" name="wkcat_meta_desc_{$language.id_lang}" value="{if isset($obj_wkcat) && isset($obj_wkcat->meta_description.{$language.id_lang})}{$obj_wkcat->meta_description.{$language.id_lang}}{/if}" id="wkcat_meta_desc_{$language.id_lang}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
            </div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_desc_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
        </div>
    	<div class="form-group">
    		<label class="control-label col-lg-3">
    			<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='To add tags click in the field, write something, and then press Enter.' mod='wkblogpost'}">
    				{l s='Meta Keywords' mod='wkblogpost'}
    			</span>
    		</label>
    		<div class="col-lg-7">
            {foreach from=$languages item=language}
                {assign var="wkcat_meta_keyword" value="wkcat_meta_keyword_`$language.id_lang`"}
                <input type="text" name="wkcat_meta_keyword_{$language.id_lang}" value="{if isset($obj_wkcat) && isset($obj_wkcat->meta_keyword.{$language.id_lang})}{$obj_wkcat->meta_keyword.{$language.id_lang}}{/if}" id="wkcat_meta_keyword_{$language.id_lang}" class="form-contrl all_wkfield" {if $id_lang != $language.id_lang}style="display:none;"{/if}>
            {/foreach}
            </div>
             {if $total_languages > 1}
            <div class="col-lg-2">
                <button type="button" id="meta_key_lang_btn" class="btn btn-default dropdown-toggle wklang" data-toggle="dropdown">
                    {$iso}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach from=$languages item=language}
                        <li>
                            <a href="javascript:hideOtherLanguage({$language.id_lang});" onclick="showProdLangField('{$language.iso_code}', {$language.id_lang});">{$language.name}</a>
                        </li>
                    {/foreach}
                </ul>
            </div>
            {/if}
    	</div>
    	<div class="form-group">
			<label class="control-label col-lg-3">
				<span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Make this post visible' mod='wkblogpost'}">
    				{l s='Status' mod='wkblogpost'}
    			</span>
    		</label>
			<div class="col-lg-9 ">
				<span class="switch prestashop-switch fixed-width-lg">
					<input type="radio" name="wkblog_status" id="wkblog_status_on" value="1" {if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == 1}checked="checked"{else if isset($obj_wkcat) && $obj_wkcat->active == 1}checked="checked"{/if}>
					<label for="wkblog_status_on">{l s='Yes' mod='wkblogpost'}</label>
					{if isset($obj_wkcat)}
                    <input type="radio" name="wkblog_status" id="wkblog_status_off" value="0" {if $obj_wkcat->active == '0'}checked="checked"{else if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == '0'}checked="checked"{/if}>
                    {else}
                    <input type="radio" name="wkblog_status" id="wkblog_status_off" value="0" {if isset($obj_wkcat->active) && $obj_wkcat->active == '0'}checked="checked"{else if isset($smarty.post.wkblog_status) && $smarty.post.wkblog_status == '0'}checked="checked"{else if !isset($smarty.post.wkblog_status)}checked="checked"{/if}>
                    {/if}
					<label for="wkblog_status_off">{l s='No' mod='wkblogpost'}</label>
					<a class="slide-button btn"></a>
				</span>
			</div>
		</div>
        <div class="panel-footer">
            <a class="btn btn-default" href="{$link->getAdminLink('AdminWkCategoryPost')}">
                <i class="process-icon-cancel"></i>{l s='Cancel' mod='wkblogpost'}
            </a>
            <button class="btn btn-default pull-right" name="submitAdd{$table}" type="submit">
                <i class="process-icon-save"></i>{l s='Save' mod='wkblogpost'}
            </button>
            <button class="btn btn-default pull-right" name="submitAdd{$table}AndStay" type="submit">
                <i class="process-icon-save"></i>{l s='Save and stay' mod='wkblogpost'}
            </button>
        </div>
    </form>
</div>
{strip}
    {addJsDef PS_ALLOW_ACCENTED_CHARS_URL = $ps_allow_accented_chars_url}
{/strip}
<script>
// for tiny mce setup
var iso = "{$iso}";
var pathCSS = "{$smarty.const._THEME_CSS_DIR_}";
var ad = "{$ad}";
$(document).ready(function(){
	{block name="autoload_tinyMCE"}
		tinySetup({
			editor_selector :"wkblog_tinymce",
			{* width : 700 *}
		});
	{/block}

    $('#file-selectbutton').click(function(e){
        $('#file').trigger('click');
    });
    $('#file-name').click(function(e){
        $('#file').trigger('click');
    });
    $('#file').change(function(e){
        var val = $(this).val();
        var file = val.split(/[\\/]/);
        $('#file-name').val(file[file.length-1]);
    });
    $('input[type="file"]').on('change', function() {
		if (typeof this.files[0] != 'undefined') {
			if (this.files[0].size > maxSizeAllowed*1000000) {
                $.growl.error({ title: "", message: filesizeError });
				setTimeout(function() {
                    location.reload();
                }, 1000);
			}
		}
	});
});

function showProdLangField(lang_iso_code, id_lang)
{
    $('.wklang').html(lang_iso_code+'<span class="caret"></span>');
    $('.all_wkfield').hide();
    $('#name_'+id_lang).show();
    $('#link_rewrite_'+id_lang).show();
    $('#div_wkcat_desc_'+id_lang).show();
    $('#wkcat_meta_title_'+id_lang).show();
    $('#wkcat_meta_keyword_'+id_lang).show();
    $('#wkcat_meta_desc_'+id_lang).show();
}
</script>
