<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostImage
{
    public function validateImageExt($image_name)
    {
        if (is_array($image_name)) {
            $img_name = $image_name['name'];
            $tmp_name = $image_name['tmp_name'];
            if (!ImageManager::isCorrectImageFileExt($img_name)
                || !ImageManager::isRealImage($tmp_name)) {
                return false;
            } else {
                return true;
            }
        } else {
            if (!ImageManager::isCorrectImageFileExt($image_name)) {
                return false;
            } else {
                return true;
            }
        }
    }

    public function uploadFeatureImage($id, $img_for)
    {
        if ($img_for == 'blog' || $img_for == 'blog_thumbnail') {
            $path = _PS_MODULE_DIR_.'wkblogpost/views/img/blog/';
            $source_index = _PS_MODULE_DIR_.'wkblogpost/index.php';
            if (is_uploaded_file($_FILES['wkpost_featured']['tmp_name']) ||
                is_uploaded_file($_FILES['wkpost_thumbnail']['tmp_name'])
            ) {
                //$img_name = $id.'_blog.jpg';
                if (!file_exists($path.'/'.$id)) {
                    @mkdir($path.'/'.$id, 0777, true);
                    @copy($source_index, $path.'/'.$id.'/index.php');
                }
                $img_name = $id.'_'.$img_for.'.jpg';
                $tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS');
                if (!$tmpName || (
                    !move_uploaded_file($_FILES['wkpost_featured']['tmp_name'], $tmpName) &&
                    !move_uploaded_file($_FILES['wkpost_thumbnail']['tmp_name'], $tmpName))
                ) {
                    return false;
                } elseif (!ImageManager::resize($tmpName, $path.'/'.$id.'/'.$img_name)) {
                    return false;
                }
            }
        } elseif ($img_for == 'default') {
            $path = _PS_MODULE_DIR_.'wkblogpost/views/img/default/';
            if (is_uploaded_file($_FILES['wktheme_default']['tmp_name'])) {
                $img_name = 'custom-default.jpg';
                if (!($tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS'))
                        || !move_uploaded_file($_FILES['wktheme_default']['tmp_name'], $tmpName)) {
                    return false;
                } elseif (!ImageManager::resize($tmpName, $path.$img_name)) {
                    return false;
                }
            }
        } elseif ($img_for == 'default_profile') {
            $path = _PS_MODULE_DIR_.'wkblogpost/views/img/default/';
            if (is_uploaded_file($_FILES['wkthumbnail_image']['tmp_name'])) {
                $img_name = 'custom-autor-profile.jpg';
                if (!($tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS'))
                        || !move_uploaded_file($_FILES['wkthumbnail_image']['tmp_name'], $tmpName)) {
                    return false;
                } elseif (!ImageManager::resize($tmpName, $path.$img_name)) {
                    return false;
                }
            }
        } elseif ($img_for == 'cat') {
            $path = _PS_MODULE_DIR_.'wkblogpost/views/img/category/';
            if (is_uploaded_file($_FILES['wkcat_featured']['tmp_name'])) {
                $img_name = $id.'_cat.jpg';
                if (!($tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS'))
                        || !move_uploaded_file($_FILES['wkcat_featured']['tmp_name'], $tmpName)) {
                    return false;
                } elseif (!ImageManager::resize($tmpName, $path.$img_name)) {
                    return false;
                }
            }
        }
    }
}
