{**
* NOTICE OF LICENSE
*
* This file is licenced under the Software License Agreement.
* With the purchase or the installation of the software in your application
* you accept the licence agreement.
*
* @author    Presta.Site
* @copyright 2015 Presta.Site
* @license   LICENSE.txt
*}
{if $psv == 1.5}
<br/><fieldset><legend>{l s='Available backups:' mod='prestabackup'}</legend>
{else}
<div class="panel"><div class="panel-heading">
    <i class="icon-cogs"></i> {l s='Available backups:' mod='prestabackup'}</div>
{/if}

{foreach from=$types item=type_name key=type}
    <div class="form-wrapper">
        <h4>{$type_name|escape:'htmlall':'UTF-8'}</h4>
        <table class="table psbackup-table">
            <thead>
                <tr>
                    <th width="10%">{l s='Creation date' mod='prestabackup'}</th>
                    <th width="20%">{l s='Filename' mod='prestabackup'}</th>
                    <th width="20%">{l s='Comment' mod='prestabackup'}</th>
                    <th width="5%">{l s='Size' mod='prestabackup'}</th>
                    <th width="15%">{l s='Local' mod='prestabackup'}</th>
                    <th width="15%"></th>
                </tr>
            </thead>
            <tbody>
            {foreach from=$avail_backups[$type] item=backup}
                <tr>
                    <td style="padding: 10px;">{$backup.created|escape:'htmlall':'UTF-8'}</td>
                    <td>{$backup.filename|escape:'htmlall':'UTF-8'}</td>
                    <td>{$backup.comment|escape:'htmlall':'UTF-8'}</td>
                    <td>{$backup.filesize|number_format:2:'.':''|escape:'htmlall':'UTF-8'} {l s='Mb' mod='prestabackup'}</td>
                    {if isset($backup.url) && $backup.url}
                        <td>
                            <a class="download-link" href="{$backup.url|escape:'htmlall':'UTF-8'}">
                                <i class="icon-download"></i> {l s='Download' mod='prestabackup'}
                            </a>
                            &nbsp;|&nbsp;
                            <a href="#" class="remove-link" id="{$backup.filename|escape:'htmlall':'UTF-8'}" data-type="{$type|escape:'htmlall':'UTF-8'}">
                                <i class="icon-remove"></i> {l s='Delete' mod='prestabackup'}
                            </a>
                        </td>
                    {else}
                        <td></td>
                    {/if}
                    <td>
                        {if $type == 'db'}
                        <a class="psbckp-restore" href="#psbckp-restore" data-filename="{$backup.filename|escape:'htmlall':'UTF-8'}" data-type="{$type|escape:'htmlall':'UTF-8'}">
                            <i class="icon-refresh"></i> {l s='Restore' mod='prestabackup'}
                        </a>
                        {/if}
                    </td>
                </tr>
            {/foreach}
            </tbody>
        </table>
    </div>
{/foreach}

{if $psv == 1.5}
</fieldset><br/>
{else}
</div>
{/if}