<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * @author    Presta.Site
 * @copyright 2015 Presta.Site
 * @license   LICENSE.txt
 */

@ini_set('max_execution_time', 14400);
ignore_user_abort(true);

require_once(dirname(__FILE__).'/../../config/config.inc.php');
require_once(dirname(__FILE__).'/../../init.php');

if (Tools::getValue('ajax') == 1) {
    $admin_cookie = new Cookie('psAdmin');
    if ($admin_cookie->id_employee) {
        $is_admin = true;
    } else {
        $is_admin = false;
    }

    //hide warning in BO
    if (Tools::getValue('hide_warning') and $is_admin) {
        $success = 0;

        Configuration::updateGlobalValue('PSB_HIDE_WARNING', 1);
        $success = 1;

        if ($success) {
            die(Tools::jsonEncode(array('success' => 1)));
        } else {
            die(Tools::jsonEncode(array('success' => 0)));
        }
    }

    if (Tools::getValue('delete_local') == 1 and $is_admin) {
        $prestaBackup = Module::getInstanceByName('prestabackup');
        $filename = Tools::getValue('filename');
        $type = Tools::getValue('type');

        $backup_dirs = $prestaBackup->getBackupDirs();
        $dir = $backup_dirs[$type];

        if (!$filename or !$type or !isset($backup_dirs[$type])) {
            die(Tools::jsonEncode(array('success' => 0)));
        }

        $dir = $backup_dirs[$type];

        if (!file_exists($dir.$filename)) {
            die(Tools::jsonEncode(array('success' => 0)));
        } else {
            $result = unlink($dir.$filename);
            die(Tools::jsonEncode(array('success' => (int)$result)));
        }
    } elseif (Tools::getValue('restore_backup') == 1 and $is_admin) {
        $success = 0;
        $filename = Tools::getValue('filename');
        $type = Tools::getValue('type');
        if (!$filename or $filename == 'undefined' or !$type or $type == 'undefined') {
            die(Tools::jsonEncode(array(
                'success' => 0,
            )));
        }
        $prestaBackup = Module::getInstanceByName('prestabackup');

        $backup_dirs = $prestaBackup->getBackupDirs();
        // if file is local
        if (file_exists($backup_dirs[$type].$filename)) {
            $file_path = $backup_dirs[$type].$filename;
        }

        $prestaBackup->restore_errors = array();
        if ($file_path && $type == 'db') {
            $result = $prestaBackup->restoreBackup($file_path, $type);
            if ($result) {
                $success = 1;
            }
        }

        die(Tools::jsonEncode(array(
            'success' => $success,
            'errors' => implode('<br/>', $prestaBackup->restore_errors),
        )));
    }
}
