{**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*}

<div class="panel">
    <div class="panel-heading">
		<i class="icon-user"></i>
		{l s='Configuration' mod='wkblogpost'}
	</div>
    <form
    class="defaultForm form-horizontal"
    action="{$current}&{if !empty($submit_action)}{$submit_action}{/if}&token={$token}"
    method="post"
    enctype="multipart/form-data">
        <div class="form-group">
            <label class="col-lg-3 control-label required">
                <span class="label-tooltip" data-toggle="tooltip" data-html="true" title="{l s='Set number of post per page' mod='wkblogpost'}">
                    {l s='No. of posts per page' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-2">
                <input type="text" name="wk_no_post" maxlength="2" value="{if isset($no_post)}{$no_post|intval}{/if}">
            </div>
        </div>
        <div class="form-group">
            <label class="control-label col-lg-3">
            <span title="" data-toggle="tooltip" class="label-tooltip" data-original-title="{l s='Show categories in side bar' mod='wkblogpost'}">
            {l s='Show Categories' mod='wkblogpost'}</span></label>
            <div class="col-lg-9">
                <span class="switch prestashop-switch fixed-width-lg side_bar_category">
                <input type="radio" id="category_on" value="1" name="category_on"
                {if isset($category_on) && $category_on == 1}checked="checked"{/if}>
                    <label for="category_on">{l s='Yes' mod='wkblogpost'}</label>
                <input type="radio" id="category_off" value="0" name="category_on" {if isset($category_on) && $category_on == 0}checked="checked"{/if}>
                    <label for="category_off">{l s='No' mod='wkblogpost'}</label>
                    <a class="slide-button btn"></a>
                </span>
                <div class="help-block">{l s='Show Categories in side bar' mod='wkblogpost'}</div>
            </div>
        </div>
        <div class="form-group" id="no_category">
            <label class="col-lg-3 control-label required">
                <span class="label-tooltip" data-toggle="tooltip" data-html="true" title="{l s='Set no. of categories to display at blog page' mod='wkblogpost'}">
                    {l s='No. of category' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-2">
                <input type="text" name="wk_no_cat" maxlength="1" value="{if isset($no_cat)}{$no_cat|intval}{/if}">
            </div>
        </div>
        <div class="form-group">
            <label class="col-lg-3 control-label required">
                <span class="label-tooltip" data-toggle="tooltip" data-html="true" title="{l s='Set author name for blog' mod='wkblogpost'}">
                    {l s='Author Name' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-3">
                <input type="text" name="wk_blog_author" value="{if isset($wk_blog_author)}{$wk_blog_author}{/if}">
            <div class="help-block">{l s='This name will be listed as author name with all blogs' mod='wkblogpost'}</div>
            </div>
        </div>
        <div class="clearfix form-group">
            <label class="control-label col-lg-3">
                <span
                    title=""
                    data-toggle="tooltip"
                    class="label-tooltip"
                    data-original-title="{l s='Show author image with all blogs' mod='wkblogpost'}">
                    {l s='Show author image' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-lg-9">
                <span class="switch prestashop-switch fixed-width-lg thumbnail_slide">
                <input
                    type="radio"
                    id="show_thumbnail_on"
                    value="1"
                    name="show_thumbnail" {if isset($show_thumbnail) && $show_thumbnail == 1}checked="checked"{/if}>
                    <label for="show_thumbnail_on">{l s='Yes' mod='wkblogpost'}</label>
                <input
                    type="radio"
                    id="show_thumbnail_off"
                    value="0"
                    name="show_thumbnail" {if isset($show_thumbnail) && $show_thumbnail == 0}checked="checked"{/if}>
                    <label for="show_thumbnail_off">{l s='No' mod='wkblogpost'}</label>
                    <a class="slide-button btn"></a>
                </span>
            </div>
        </div>
        <div id="wkthumbnail_img" style="display:none;">
            <div class="form-group">
                <label class="col-lg-3 control-label">
                    <span
                        class="label-tooltip"
                        data-toggle="tooltip"
                        data-html="true"
                        title="{l s='This thumbnail image will be shown with your every blog' mod='wkblogpost'}">
                        {l s='Upload Author Image' mod='wkblogpost'}
                    </span>
                </label>
                <div class="col-sm-7">
                    <div class="row">
                        <div class="col-lg-7">
                            <input
                                id="profile_file"
                                type="file"
                                name="wkthumbnail_image"
                                class="hide" />
                            <div class="dummyfile input-group">
                                <span class="input-group-addon"><i class="icon-file"></i></span>
                                <input
                                    id="profile_file_name"
                                    type="text"
                                    class="disabled"
                                    name="filename"
                                    readonly />
                                <span class="input-group-btn">
                                    <button
                                            id="profile_file_selectbutton"
                                            type="button"
                                            name="submitAddAttachments"
                                            class="btn btn-default">
                                        <i class="icon-folder-open"></i> {l s='Choose a file' mod='wkblogpost'}
                                    </button>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            {if isset($default_profile)}
                <div class="form-group">
                    <label class="control-label col-lg-3">

                    </label>
                    <div class="col-lg-7">
                        <input
                            type="hidden"
                            name="default_profile_img"
                            value="{if isset($default_profile)}{$default_profile}{/if}">
                        <img
                            width="65"
                            class="img-responsive"
                            src="{$default_profile_img}"
                            title="{l s='Profile Image' mod='wkblogpost'}">
                        <div class="help-block">
                            {l s='Best fit for profile image 65 x 65' mod='wkblogpost'}
                        </div>
                        {if isset($show_delete_for_author_img)}
                            <p style="margin-top:10px;">
                                <a
                                    href="{$link->getAdminLink('AdminWkBlogPostConfiguration')}&id_profile_delete=1"
                                    class="btn btn-default">
                                    <i class="icon-trash"></i> {l s='Delete' mod='wkblogpost'}
                                </a>
                            </p>
                        {/if}
                    </div>
                </div>
            {/if}
        </div>
        <div class="clearfix form-group">
            <label class="col-lg-3 control-label">
                <span
                    class="label-tooltip"
                    data-toggle="tooltip"
                    data-html="true"
                    title="{l s='Default blog image' mod='wkblogpost'}">
                    {l s='Default blog image' mod='wkblogpost'}
                </span>
            </label>
            <div class="col-sm-7">
                <div class="row">
                    <div class="col-lg-7">
                        <input
                            id="file"
                            type="file"
                            name="wktheme_default"
                            class="hide" />
                        <div class="dummyfile input-group">
                            <span class="input-group-addon"><i class="icon-file"></i></span>
                            <input
                                id="file-name"
                                type="text"
                                class="disabled"
                                name="filename"
                                readonly />
                            <span class="input-group-btn">
                                <button
                                        id="file-selectbutton"
                                        type="button"
                                        name="submitAddAttachments"
                                        class="btn btn-default">
                                    <i class="icon-folder-open"></i> {l s='Choose a file' mod='wkblogpost'}
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {if isset($default_img)}
            <div class="form-group">
                <label class="control-label col-lg-3">

                </label>
                <div class="col-lg-7">
                    <input
                        type="hidden"
                        name="default_blogimg"
                        value="{if isset($default)}{$default}{/if}">
                    <img
                        class="wkfeature_img img img-thumbnail"
                        src="{$default_img}"
                        title="{l s='Feature Image' mod='wkblogpost'}">
                    {if isset($show_delete_for_default_img)}
                        <p>
                            <a
                                href="{$link->getAdminLink('AdminWkBlogPostConfiguration')}&id_delete=1"
                                class="btn btn-default">
                                <i class="icon-trash"></i>{l s='Delete' mod='wkblogpost'}
                            </a>
                        </p>
                    {/if}
                </div>
            </div>
        {/if}
        <div class="panel-footer">
            <button
                type="submit"
                name="SubmitBlogConfiguration"
                class="btn btn-default pull-right">
            <i class="process-icon-save"></i>{l s='Save' mod='wkblogpost'}</button>
        </div>
    </form>
</div>