<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostSearchModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $this->display_column_left = false;
        $this->display_column_right = false;
        $id_lang = $this->context->language->id;
        $string = trim(Tools::getValue('q'));
        $page_no = Tools::getValue('p');
        $obj_wkpost = new WkBlogPostData();
        $obj_wkcat = new WkBlogPostCategory();
        $active_cats = $obj_wkcat->activeCategories($id_lang);
        $all_posts = $obj_wkpost->getActivePostId($id_lang);
        $page_no = Tools::getValue('page');
        if (!$page_no) {
            $page_no = 1;
        }
        $no_post = Configuration::get('WK_NO_OF_BLOG_POST');

        if ($page_no > 1) {
            $start = ($page_no * $no_post) - $no_post;
        } else {
            $start = 0;
        }
        if ($string) {
            $result = $obj_wkpost->searchBlogByString($string, $id_lang, $start, $no_post);
            if ($result) {
                // pagination
                if (($result['total'] / $no_post) > $page_no) {
                    $this->context->smarty->assign('pagination', 1);
                }
                unset($result['total']);
                $this->context->smarty->assign(
                    array(
                        'listing_posts' => $result
                    )
                );
            }
        }
        if (!is_array($active_cats)) {
            $active_cats = array();
        }
        if (!is_array($all_posts)) {
            $all_posts = array();
        }
        $this->context->smarty->assign(
            array(
                'time' => time(),
                'ps_module_dir' => _MODULE_DIR_,
                'all_category' => array_values($active_cats),
                'string' => $string,
                'module_path' => _PS_MODULE_DIR_,
                'next_page' => $page_no + 1,
                'previous_page' => $page_no - 1,
                'no_cat' => Configuration::get('WK_NO_OF_BLOG_CATEGORY'),
                'category_on' => Configuration::get('WK_BLOG_CATEGORY_ON'),
                'wk_rewrite_enabled' => Configuration::get('PS_REWRITING_SETTINGS'),
                'controller' => Tools::getValue('controller'),
            )
        );
        $this->setTemplate('module:wkblogpost/views/templates/front/blogpost_list.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        $breadcrumb['links'][] = array(
            'title' => $this->module->l('Search', 'wkblogpost'),
            'url' => 'javascript:void(0)',
        );

        return $breadcrumb;
    }

    public function setMedia()
    {
        parent::setMedia();
        $this->registerStylesheet(
            'bloglist',
            'modules/'.$this->module->name.'/views/css/wkbloglist.css'
        );
    }
}
