<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostBlogPostModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        parent::initContent();
        $this->display_column_left = false;
        $this->display_column_right = false;
        $id_lang = $this->context->language->id;
        $page_no = Tools::getValue('page');
        if (!$page_no) {
            $page_no = 1;
        }
        $no_post = Configuration::get('WK_NO_OF_BLOG_POST');
        if ($page_no > 1) {
            $start = ($page_no * $no_post) - $no_post;
            $limit = $start.','.$no_post;
        } else {
            $limit = ($page_no == 1 ? 0 : $page_no).','.$no_post;
        }
        $obj_wkpost = new WkBlogPostData();
        $obj_wkcat = new WkBlogPostCategory();

        $all_posts = $obj_wkpost->getActivePostId($id_lang);
        if (!empty($all_posts)) {
            if ((count($all_posts) / $no_post) > $page_no) {
                $this->context->smarty->assign('pagination', 1);
            }
        }
        $active_cats = $obj_wkcat->activeCategories($id_lang);
        if (!is_array($active_cats)) {
            $active_cats = array();
        }
        $listing_posts = $obj_wkpost->getActivePostByLangIdWithLimit($id_lang, $limit);
        if (!is_array($all_posts)) {
            $all_posts = array();
        }
        $this->context->smarty->assign(
            array(
                'time' => time(),
                'ps_module_dir' => _MODULE_DIR_,
                'listing_posts' => $listing_posts,
                'controller' => Tools::getValue('controller'),
                'next_page' => $page_no + 1,
                'previous_page' => $page_no - 1,
                'module_path' => _PS_MODULE_DIR_,
                'wk_rewrite_enabled' => Configuration::get('PS_REWRITING_SETTINGS'),
                'category_on' => Configuration::get('WK_BLOG_CATEGORY_ON'),
                'no_cat' => Configuration::get('WK_NO_OF_BLOG_CATEGORY'),
                'all_category' => array_values($active_cats),
            )
        );
        $this->setTemplate('module:wkblogpost/views/templates/front/blogpost_list.tpl');
    }

    public function getBreadcrumbLinks()
    {
        $breadcrumb = parent::getBreadcrumbLinks();
        $breadcrumb['links'][] = array(
            'title' => $this->module->l('Blog', 'wkblogpost'),
            'url' => $this->context->link->getModuleLink($this->module->name, 'blogpost'),
        );

        return $breadcrumb;
    }

    public function setMedia()
    {
        parent::setMedia();
        $this->registerStylesheet(
            'bloglist',
            'modules/'.$this->module->name.'/views/css/wkbloglist.css'
        );
    }
}
