<?php
/**
* 2010-2021 Webkul.
*
* NOTICE OF LICENSE
*
* All right is reserved,
* Please go through LICENSE.txt file inside our module
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade this module to newer
* versions in the future. If you wish to customize this module for your
* needs please refer to CustomizationPolicy.txt file inside our module for more information.
*
* @author Webkul IN
* @copyright 2010-2021 Webkul IN
* @license LICENSE.txt
*/

class WkBlogPostCategory extends ObjectModel
{
    public $id_wk_blogpost_category;
    public $is_default;
    public $date_add;
    public $date_upd;
    public $active;
    // public $id_shop;
    public $title;
    public $link_rewrite;
    public $description;
    public $meta_title;
    public $meta_keyword;
    public $meta_description;

    public static $definition = array(
        'table' => 'wk_blogpost_category',
        'primary' => 'id_wk_blogpost_category',
        'multilang' => true,
        'multilang_shop' => true,
        'fields' => array(
            'is_default' => array('type' => self::TYPE_BOOL,'validate' => 'isBool', 'shop'=>true),
            'date_add' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'shop'=>true),
            'date_upd' => array('type' => self::TYPE_DATE, 'validate' => 'isDateFormat', 'shop'=>true),
            'active' => array('type' => self::TYPE_BOOL,'validate' => 'isBool', 'shop'=>true),
            // 'id_shop' => array('type' => self::TYPE_INT, 'shop' => true),
            //multi lang fields
            'title' => array('type' => self::TYPE_STRING, 'required' => true,
            'lang' => true, 'validate' => 'isCatalogName'),
            'link_rewrite' => array('type' => self::TYPE_STRING, 'lang' => true,
            'validate' => 'isLinkRewrite', 'required' => true, 'size' => 128),
            'meta_title' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCatalogName'),
            'meta_keyword' => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isCatalogName'),
            'meta_description' => array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml'),
            'description' => array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml'),
        ),
    );

    public function __construct($id = null, $idLang = null, $idShop = null)
    {
        parent::__construct($id, $idLang, $idShop);
        Shop::addTableAssociation(
            'wk_blogpost_category',
            array('type' => 'shop', 'primary' => 'id_wk_blogpost_category')
        );
        Shop::addTableAssociation(
            'wk_blogpost_category_lang',
            array('type' => 'fk_shop', 'primary' => 'id_wk_blogpost_category')
        );
    }


    public static function getDefaultCategory()
    {
        $sql = 'SELECT * FROM '._DB_PREFIX_.'wk_blogpost_category as wbc';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wbc');
        $sql .=  ' where wk_blogpost_category_shop.`is_default` = 1';
        return Db::getInstance()->getRow($sql);
    }

    public function activeCategories($id_lang)
    {
        $sql = 'SELECT * FROM '._DB_PREFIX_.'wk_blogpost_category wkpscat
        LEFT JOIN '._DB_PREFIX_.'wk_blogpost_category_lang wkpscatlang
        ON (wkpscat.`id_wk_blogpost_category` = wkpscatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpscat');
        $sql .=  ' where wk_blogpost_category_shop.`active` = 1 AND `id_lang` = '.(int) $id_lang;
        $sql .= Shop::addSqlRestrictionOnLang('wkpscatlang');
        $result = Db::getInstance()->executeS($sql);
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public function activeCategoriesByCategoryName($category, $id_lang)
    {
        $sql = 'SELECT * FROM '._DB_PREFIX_.'wk_blogpost_category wkpscat
        LEFT JOIN '._DB_PREFIX_.'wk_blogpost_category_lang wkpscatlang
        ON (wkpscat.`id_wk_blogpost_category` = wkpscatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpscat');
        $sql .=  ' where wk_blogpost_category_shop.`active` = 1 AND `id_lang` = '.(int) $id_lang.'
        AND wkpscatlang.`link_rewrite` = \''.pSQL($category).'\'';
        $sql .= Shop::addSqlRestrictionOnLang('wkpscatlang');
        // echo $sql;die;
        $result = Db::getInstance()->getRow(
            $sql
        );
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }

    public static function removeDefaultCategory($id)
    {
        $categoryObj = new WkBlogPostCategory((int) $id);
        $categoryObj->is_default = 0;
        return $categoryObj->update();
    }

    public function getAllCategories($id_lang)
    {
        // echo "D";die;
        $sql = 'SELECT * FROM '._DB_PREFIX_.'wk_blogpost_category wkpscat
			LEFT JOIN '._DB_PREFIX_.'wk_blogpost_category_lang wkpscatlang
            on (wkpscat.`id_wk_blogpost_category` = wkpscatlang.`id_wk_blogpost_category`)';
        $sql .= Shop::addSqlAssociation('wk_blogpost_category', 'wkpscat');
        $sql .= ' where `id_lang` = '.(int) $id_lang;
        $sql .= Shop::addSqlRestrictionOnLang('wkpscatlang');
        $result = Db::getInstance()->executeS($sql);
        if ($result) {
            return $result;
        } else {
            return false;
        }
    }
}
